clc
clear all
close all
set(0,'defaultTextInterpreter','latex'); %trying to set the default
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');
all_marks = {'o','+','*','.','x','s','d','^','v','>','<','p','h'};

%% Plot automatico misure laser
% Dati
Spessore=[50 100 120 150 200];
ps=4;
x0_precarico=[0 10 30 50 70];
test=[1 2 3];
pa=101325;
D_foro=[6 8];

for index_foro=1:length(D_foro)
    dforo=D_foro(index_foro);
    for index_Spessore=1:length(Spessore)
        Sp=Spessore(index_Spessore);
        if (dforo==6 && Sp==100) || (dforo==8 && Sp==50) || (dforo==8 && Sp==120)
            x0=x0_precarico(1:4);
        elseif (dforo==6 && Sp==120) || (dforo==8 && Sp==100) || (dforo==8 && Sp==150)
            x0=x0_precarico(1:3);
        elseif dforo==6 && (Sp==150 || Sp==200)
            x0=x0_precarico(1);
        elseif dforo==6 && Sp==50
            x0=x0_precarico;
        elseif dforo==8 && Sp==200
            x0=[0 10 20];
        end
        for index_x0=1:length(x0)
        x_0=x0(index_x0);
            for index_Test=1:length(test)
                Test=test(index_Test);
                %Caricamento Automatico Dati
                Misura=['load Test_Pattino_f' num2str(dforo) '_s' num2str(Sp) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test)];
                eval(Misura)

%                 figure(1)
%                 plot_k=['plot(Sp, k_f' num2str(dforo) '_s' num2str(Sp) '_ps' num2str(ps) '_x' num2str(x_0) '_' num2str(Test),',''LineStyle'',''none'',''Marker'',all_marks{mod(index_Test,18)}), hold on'];
%                 eval(plot_k)
%                 title('Confronto rigidezze')
%                 xlabel('$Spessore$ ($\mu m$)')
%                 ylabel('$k$ ($\frac{N}{m}$)')
%                 grid on

            end
        end
    end
end

%Calcolo media dei k senza precarico
k_medi_f6_x0=[mean([k_f6_s50_ps4_x0_1 k_f6_s50_ps4_x0_2 k_f6_s50_ps4_x0_3]) mean([k_f6_s100_ps4_x0_1 k_f6_s100_ps4_x0_2 k_f6_s100_ps4_x0_3]) mean([k_f6_s120_ps4_x0_1 k_f6_s120_ps4_x0_2 k_f6_s120_ps4_x0_3]) mean([k_f6_s150_ps4_x0_1 k_f6_s150_ps4_x0_2 k_f6_s150_ps4_x0_3])];
k_medi_f8_x0=[mean([k_f8_s50_ps4_x0_1 k_f8_s50_ps4_x0_2 k_f8_s50_ps4_x0_3]) mean([k_f8_s100_ps4_x0_1 k_f8_s100_ps4_x0_2 k_f8_s100_ps4_x0_3]) mean([k_f8_s120_ps4_x0_1 k_f8_s120_ps4_x0_2 k_f8_s120_ps4_x0_3]) mean([k_f8_s150_ps4_x0_1 k_f8_s150_ps4_x0_2 k_f8_s150_ps4_x0_3])];

%Crea una curva passante per i punti medi per ogni spessore
p_f6=polyfit(Spessore(1:end-1),k_medi_f6_x0,5);
p_f8=polyfit(Spessore(1:end-1),k_medi_f8_x0,5);
Spessore_f=linspace(Spessore(1),Spessore(end-1));
k_interp_f6=polyval(p_f6,Spessore_f);
k_interp_f8=polyval(p_f8,Spessore_f);

stringa_k_f6_pattino=['k_interp_f6_pattino' '=k_interp_f6;'];
stringa_k_f8_pattino=['k_interp_f8_pattino' '=k_interp_f8;'];
stringa_Spessore_f_pattino=['Spessore_f_pattino' '=Spessore_f;'];

Salvataggio=['save Andamento_k_pattino k_interp_f6_pattino k_interp_f8_pattino Spessore_f_pattino'];

eval(stringa_k_f6_pattino)
eval(stringa_k_f8_pattino)
eval(stringa_Spessore_f_pattino)
eval(Salvataggio)

%Calcolo deviazione standard per ogni spessore
dev_s50_f6=std([k_f6_s50_ps4_x0_1 k_f6_s50_ps4_x0_2 k_f6_s50_ps4_x0_3]);
dev_s100_f6=std([k_f6_s100_ps4_x0_1 k_f6_s100_ps4_x0_2 k_f6_s100_ps4_x0_3]);
dev_s120_f6=std([k_f6_s120_ps4_x0_1 k_f6_s120_ps4_x0_2 k_f6_s120_ps4_x0_3]);
dev_s150_f6=std([k_f6_s150_ps4_x0_1 k_f6_s150_ps4_x0_2 k_f6_s150_ps4_x0_3]);
dev_f6=[dev_s50_f6 dev_s100_f6 dev_s120_f6 dev_s150_f6];
dev_s50_f8=std([k_f8_s50_ps4_x0_1 k_f8_s50_ps4_x0_2 k_f8_s50_ps4_x0_3]);
dev_s100_f8=std([k_f8_s100_ps4_x0_1 k_f8_s100_ps4_x0_2 k_f8_s100_ps4_x0_3]);
dev_s120_f8=std([k_f8_s120_ps4_x0_1 k_f8_s120_ps4_x0_2 k_f8_s120_ps4_x0_3]);
dev_s150_f8=std([k_f8_s150_ps4_x0_1 k_f8_s150_ps4_x0_2 k_f8_s150_ps4_x0_3]);
dev_f8=[dev_s50_f8 dev_s100_f8 dev_s120_f8 dev_s150_f8];


figure(2)
plot(Spessore(1),k_f6_s50_ps4_x0_1,'bo','Linewidth',4),hold on
plot(Spessore(1),k_f6_s50_ps4_x0_2,'bo','Linewidth',4),hold on
plot(Spessore(1),k_f6_s50_ps4_x0_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x10_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x10_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x10_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x30_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x30_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x30_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x50_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x50_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x50_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x70_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x70_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f6_s50_ps4_x70_3,'bo','Linewidth',4),hold on

plot(Spessore(2),k_f6_s100_ps4_x0_1,'ro','Linewidth',4),hold on
plot(Spessore(2),k_f6_s100_ps4_x0_2,'ro','Linewidth',4),hold on
plot(Spessore(2),k_f6_s100_ps4_x0_3,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x10_1,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x10_2,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x10_3,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x30_1,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x30_2,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x30_3,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x50_1,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x50_2,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f6_s100_ps4_x50_3,'ro','Linewidth',4),hold on

plot(Spessore(3),k_f6_s120_ps4_x0_1,'go','Linewidth',4),hold on
plot(Spessore(3),k_f6_s120_ps4_x0_2,'go','Linewidth',4),hold on
plot(Spessore(3),k_f6_s120_ps4_x0_3,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x10_1,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x10_2,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x10_3,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x30_1,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x30_2,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f6_s120_ps4_x30_3,'go','Linewidth',4),hold on

plot(Spessore(4),k_f6_s150_ps4_x0_1,'ko','Linewidth',4),hold on
plot(Spessore(4),k_f6_s150_ps4_x0_2,'ko','Linewidth',4),hold on
plot(Spessore(4),k_f6_s150_ps4_x0_3,'ko','Linewidth',4),hold on

% plot(Spessore(5),k_f6_s200_ps4_x0_1,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f6_s200_ps4_x0_2,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f6_s200_ps4_x0_3,'yo','Linewidth',4),hold on

plot(Spessore(1:end-1),k_medi_f6_x0,'kx','LineWidth',2)
plot(Spessore_f,k_interp_f6,'k--','LineWidth',2)
errorbar(Spessore(1:end-1),k_medi_f6_x0,dev_f6,'x','LineWidth',2)
xlim([Spessore(1),Spessore(end-1)])
ylim([0,max([k_f6_s150_ps4_x0_1 k_f6_s150_ps4_x0_2 k_f6_s150_ps4_x0_3])])
title('Confronto rigidezze pattino foro 6')
xlabel('$Spessore$ ($\mu m$)')
ylabel('$k$ ($\frac{N}{m}$)')
grid on


figure(3)
plot(Spessore(1),k_f8_s50_ps4_x0_1,'bo','Linewidth',4),hold on
plot(Spessore(1),k_f8_s50_ps4_x0_2,'bo','Linewidth',4),hold on
plot(Spessore(1),k_f8_s50_ps4_x0_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x10_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x10_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x10_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x30_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x30_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x30_3,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x50_1,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x50_2,'bo','Linewidth',4),hold on
% plot(Spessore(1),k_f8_s50_ps4_x50_3,'bo','Linewidth',4),hold on

plot(Spessore(2),k_f8_s100_ps4_x0_1,'ro','Linewidth',4),hold on
plot(Spessore(2),k_f8_s100_ps4_x0_2,'ro','Linewidth',4),hold on
plot(Spessore(2),k_f8_s100_ps4_x0_3,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x10_1,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x10_2,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x10_3,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x30_1,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x30_2,'ro','Linewidth',4),hold on
% plot(Spessore(2),k_f8_s100_ps4_x30_3,'ro','Linewidth',4),hold on

plot(Spessore(3),k_f8_s120_ps4_x0_1,'go','Linewidth',4),hold on
plot(Spessore(3),k_f8_s120_ps4_x0_2,'go','Linewidth',4),hold on
plot(Spessore(3),k_f8_s120_ps4_x0_3,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x10_1,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x10_2,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x10_3,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x30_1,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x30_2,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x30_3,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x50_1,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x50_2,'go','Linewidth',4),hold on
% plot(Spessore(3),k_f8_s120_ps4_x50_3,'go','Linewidth',4),hold on

plot(Spessore(4),k_f8_s150_ps4_x0_1,'ko','Linewidth',4),hold on
plot(Spessore(4),k_f8_s150_ps4_x0_2,'ko','Linewidth',4),hold on
plot(Spessore(4),k_f8_s150_ps4_x0_3,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x10_1,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x10_2,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x10_3,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x30_1,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x30_2,'ko','Linewidth',4),hold on
% plot(Spessore(4),k_f8_s150_ps4_x30_3,'ko','Linewidth',4),hold on

% plot(Spessore(5),k_f8_s200_ps4_x0_1,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x0_2,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x0_3,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x10_1,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x10_2,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x10_3,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x20_1,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x20_2,'yo','Linewidth',4),hold on
% plot(Spessore(5),k_f8_s200_ps4_x20_3,'yo','Linewidth',4),hold on

plot(Spessore(1:end-1),k_medi_f8_x0,'kx','LineWidth',2)
plot(Spessore_f,k_interp_f8,'k--','LineWidth',2)
errorbar(Spessore(1:end-1),k_medi_f8_x0,dev_f8,'x','LineWidth',2)
xlim([Spessore(1),Spessore(end-1)])
ylim([0,max([k_f8_s150_ps4_x0_1 k_f8_s150_ps4_x0_2 k_f8_s150_ps4_x0_3])])
title('Confronto rigidezze pattino foro 8')
xlabel('$Spessore$ ($\mu m$)')
ylabel('$k$ ($\frac{N}{m}$)')
grid on

